<?php

namespace Import\ApiBundle\Entity;

use Doctrine\ORM\Mapping as ORM;
use JMS\Serializer\Annotation\ExclusionPolicy;
use JMS\Serializer\Annotation\Expose;
use JMS\Serializer\Annotation\Groups as AnnotationGroups;

/**
 * PaymentMin
 *
 * @ORM\Table(name="payment_min")
 * @ORM\Entity(repositoryClass="Import\ApiBundle\Repository\PaymentMinRepository")
 *
 * @ExclusionPolicy("all")
 */
class PaymentMin
{
    /**
     * @var integer
     *
     * @ORM\Column(name="id", type="integer")
     * @ORM\Id
     * @ORM\GeneratedValue(strategy="AUTO")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $id;

    /**
     * @var \Date
     *
     * @ORM\Column(name="dataFrom", type="date")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $dataFrom;

    /**
     * @var \Date
     *
     * @ORM\Column(name="dataTo", type="date", nullable=true)
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $dataTo;

    /**
     * @var float
     *
     * @ORM\Column(name="value", type="float")
     *
     * @Expose
     * @AnnotationGroups({"indicatorsDetails"})
     */
    private $value;

    /**
     * Get id
     *
     * @return integer 
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Set dataFrom
     *
     * @param \DateTime $dataFrom
     * @return Interest
     */
    public function setDataFrom($dataFrom)
    {
        $this->dataFrom = $dataFrom;
    
        return $this;
    }

    /**
     * Get dataFrom
     *
     * @return \DateTime 
     */
    public function getDataFrom()
    {
        return $this->dataFrom;
    }

    /**
     * Set dataTo
     *
     * @param \DateTime $dataTo
     * @return Interest
     */
    public function setDataTo($dataTo)
    {
        $this->dataTo = $dataTo;
    
        return $this;
    }

    /**
     * Get dataTo
     *
     * @return \DateTime 
     */
    public function getDataTo()
    {
        return $this->dataTo;
    }

    /**
     * Set value
     *
     * @param float $value
     * @return Interest
     */
    public function setValue($value)
    {
        $this->value = $value;
    
        return $this;
    }

    /**
     * Get value
     *
     * @return float 
     */
    public function getValue()
    {
        return $this->value;
    }
}